// v1.00 of the Simulator

#include <iostream>
#include "Simulator.h"
#include <vector>
#include <set>
#include <cmath>
#include <algorithm>

using namespace std;

set<int> getUniqueRandomNumbersFromRange(int n, int a, int b){
    // -- Create a vector v, shuffle it, and add first n to set
    set<int> s;
    vector<int> v=vector<int>(0);
    for(int i=a; i<=b; i++){
        v.push_back(i);
    }
    // -- Now randomise, and add first n elements to return set s
    random_shuffle(v.begin(), v.end());
    for(int i=0; i<n; i++){
        s.insert(v[i]);
    }
    return s;
}

// LAUNCHEDFLEET
LaunchedFleet::LaunchedFleet():fleet(NULL),arrivalYear(0){
}
LaunchedFleet::LaunchedFleet(Fleet* f, int y):fleet(f),arrivalYear(y){
}
bool LaunchedFleet::operator<(LaunchedFleet const &other) const {
    return arrivalYear<other.arrivalYear;
}
void LaunchedFleet::printArrival(){
    cout<<fleet->getCorporationName()<<" arrives at planet:"<<endl;
    cout<<"- Arrival year: "<<arrivalYear<<endl;
    cout<<"- Colonists living on board: "<<fleet->getColonistCount()<<endl;
}

// PLANET
Planet::Planet():owner(NULL),population(0),growthFactor(1.05),lastFleetArrivalYear(0){
}
void Planet::growPopulation(const int year){
    int startpop=population;
    int period=year-lastFleetArrivalYear;
    double dpop=(double)population;
    for(int i=0; i<period; i++){
        dpop*=growthFactor;
    }
    population=(int)dpop;
    lastFleetArrivalYear=year;    // -- Don't forget to update the time on this planet!
    int growth=population-startpop;
    cout<<"- Population growth since last fleet arrival: "<<growth<<endl;
}
void Planet::resolveFleetArrival(Fleet* f){
    // -- Check if planet already has an owner. If not, arrival becomes owner
    if(owner==NULL) {
        owner=f;
        population=owner->getColonistCount();
        cout<<"- "<<owner->getCorporationName()<<" is the new owner of Gaia"<<endl;
    }
    else {
        if (f->getColonistCount()> population) {
            owner=f;
            population=owner->getColonistCount();
            cout<<"- "<<owner->getCorporationName()<<" is the new owner of Gaia"<<endl;
        }
        else {
            cout<<"- "<<f->getCorporationName()<<" arrives with fewer colonists"<<endl;
            cout<<"- "<<owner->getCorporationName()<<" remains the owner of Gaia"<<endl;
        }
    }
    cout<<endl;
}
Fleet* Planet::getOwner() const{
    return owner;
}
int Planet::getPopulation() const {
    return population;
}
int Planet::getLastFleetArrivalYear() const {
    return lastFleetArrivalYear;
}
void Planet::printState() const{
    if(owner==NULL){
        cout<<"- Current planet owner: Unclaimed"<<endl;
    }
    else{
        cout<<"- Current planet owner: "<<owner->getCorporationName()<<endl;
    }
    cout<<"- Current population: "<<population<<endl;
}

// SPACETRAVELSIMULATOR
SpaceTravelSimulator::SpaceTravelSimulator():fleet(NULL),alpha(10),planetDistance(33){
}
SpaceTravelSimulator::SpaceTravelSimulator(Fleet* f):fleet(f),alpha(10),planetDistance(33){
}
void SpaceTravelSimulator::alienAttack(){
    // -- Find a random colonist ship and attack it
    vector<Ship*> cships=fleet->colonyShips();
    random_shuffle(cships.begin(), cships.end());
    bool attackSucces=false;
    for(unsigned int i=0; i<cships.size() && !attackSucces; i++) {
        ColonyShip* poorBuggers=dynamic_cast<ColonyShip*>(cships[i]);
        if(poorBuggers){          // -- Test if dynamic cast worked
            if(!poorBuggers->isDestroyed()){
                cout<<poorBuggers->getTypeName()<<" attacked - ";
                int c=fleet->getColonistCount();
                poorBuggers->destroy();
                cout<<c-fleet->getColonistCount()<<" colonists died"<<endl;
                attackSucces=true;  // -- Only do 1
            }
        }
        else{
            cout<<"Warning! Trying to attack a non-colony ship!"<<endl;
        }
    }
}
void SpaceTravelSimulator::diseaseInfection(){
    // -- Only do something if there's no medic ship
    if(!fleet->hasMedic()){
        // -- Find a random colonist ship and infect it
        vector<Ship*> cships=fleet->colonyShips();
        random_shuffle(cships.begin(), cships.end());
        bool infectionSucces=false;
        for (unsigned int i=0; i<cships.size() && !infectionSucces; i++) {
            ColonyShip* poorBuggers=dynamic_cast<ColonyShip*>(cships[i]);
            if (poorBuggers){          // -- Test if dynamic cast worked
                if (!poorBuggers->isDestroyed()){
                    cout<<poorBuggers->getTypeName()<<" infected"<<endl;
                    poorBuggers->infect();
                    infectionSucces=true;  // -- Only do 1
                }
            }
            else{
                cout<<"Warning! Trying to infect a non-colony ship!"<<endl;
            }
        }
    }
    else{
        cout<<"Disease is prevented by the Medic!"<<endl;
    }
}
int SpaceTravelSimulator::simulateTravel(){
    cout<<"Simulating travel of "<<fleet->getCorporationName()<<endl;
    // -- First half, all is fine
    int w1=fleet->getWeight();
    cout<<"Colonists travelling: "<<fleet->getColonistCount()<<"; Fleet weight: "<<w1<<endl;
    float dur_1sthalf=calcDuration(planetDistance/2,w1);
    cout<<"First half of journey takes "<<dur_1sthalf<<" lightyears"<<endl;
    // -- But then... disaster strikes!
    cout<<"Fleet attacked by alien!"<<endl;
    alienAttack();
    cout<<"Fleet infected by disease!"<<endl;
    diseaseInfection();
    int w2=fleet->getWeight();
    cout<<"Colonists travelling: "<<fleet->getColonistCount()<<"; Fleet weight: "<<w2<<endl;
    float dur_2ndhalf=calcDuration(planetDistance/2,w2);
    cout<<"Second half of journey takes "<<dur_2ndhalf<<" lightyears"<<endl;
    int duration = dur_1sthalf+dur_2ndhalf; // - Explicit conversion
    cout<<"Total journey duration: "<<duration<<" lightyears"<<endl;
    cout<<endl;
    return duration;
}
float SpaceTravelSimulator::calcDuration(float dist, int weight){
    float w=(float)fleet->getWeight();
    float speed=alpha/sqrt(w);   // - In light years per year
    float dur=dist/speed;
    return dur;
}

// SIMULATOR
Simulator::Simulator():gaia(Planet()),year(0){
}
Simulator::Simulator(vector<Fleet*> f):gaia(Planet()),year(0){
    fleets=vector<LaunchedFleet>(f.size());
    for(unsigned int i=0; i<f.size(); i++){
        fleets[i]=LaunchedFleet(f[i],0);
    }
}
void Simulator::addFleet(Fleet *f){
    fleets.push_back(LaunchedFleet(f,0));
}
void Simulator::launchFleets(){
    cout<<"==============================="<<endl;
    cout<<"Now launching "<<fleets.size()<<" fleets"<<endl;
    cout<<"==============================="<<endl;
    processAllFleetJourneys();  // - Sets the arrival years vector, and processes fleet modifications
    resolveAllFleetArrivals();  // - Resolves planet ownership in order of arrival
}
void Simulator::processAllFleetJourneys(){
    for(unsigned int i=0; i<fleets.size(); i++){
        spacetravel=SpaceTravelSimulator(fleets[i].fleet);  // - Set spacetravel to process fleet i
        fleets[i].arrivalYear=spacetravel.simulateTravel();
    }
}
void Simulator::resolveAllFleetArrivals(){
    // -- Sort fleets by arrival year, then resolve arrival to Gaia by that order...
    cout<<"==============================="<<endl;
    cout<<"Resolving fleet arrivals:"<<endl;
    cout<<"==============================="<<endl;
    sort(fleets.begin(),fleets.end());
    vector<LaunchedFleet>::iterator it;
    for (it=fleets.begin(); it!=fleets.end(); ++it){
        it->printArrival();
        gaia.growPopulation(it->arrivalYear);
        gaia.printState();
        gaia.resolveFleetArrival(it->fleet);
    }
}
void Simulator::report() const{
    Fleet* winner=gaia.getOwner();
    cout<<"Final owner of Gaia is: "<<winner->getCorporationName()<<endl;
    cout<<"- Year at which spacerace is resolved: "<<gaia.getLastFleetArrivalYear()<<endl;
    cout<<"- Final population: "<<gaia.getPopulation()<<endl;
}
